/*
   vdev: a virtual device manager for *nix
   Copyright (C) 2023  Aitor C.Z.

   This program is dual-licensed: you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 3 or later as 
   published by the Free Software Foundation. For the terms of this 
   license, see LICENSE.GPLv3+ or <http://www.gnu.org/licenses/>.

   You are free to use this program under the terms of the GNU General
   Public License, but WITHOUT ANY WARRANTY; without even the implied 
   warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
   See the GNU General Public License for more details.

   Alternatively, you are free to use this program under the terms of the 
   Internet Software Consortium License, but WITHOUT ANY WARRANTY; without
   even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
   For the terms of this license, see LICENSE.ISC or 
   <http://www.isc.org/downloads/software-support-policy/isc-license/>.
*/

#ifndef _VDEV_MISC_H_
#define _VDEV_MISC_H_

#include "util.h"
#include <stdbool.h>

C_LINKAGE_BEGIN

char *strncpy_t(char *out, size_t outsz, const char *in, size_t insz);
void kill_previous_instances(const char *binary);
bool is_running(const char *binary);
void itoa10_safe(int val, char *str);
FILE *epopen(const char *cmd,  pid_t *pid);  /* similar to vdev_subprocess() */
void send_to_background();

int sysfs_get_parent_device(char const *dev_path, 
                            char **ret_parent_device, size_t *ret_parent_device_len);
bool sysfs_get_parent_with_subsystem(char const *device_path, char const *subsystem_name);

int get_user_sessions();
   
C_LINKAGE_END

#endif // _VDEV_MISC_H_ 
