/* See LICENSE file for copyright and license details. */ 
/* Check if a device is a partition and its disk is removable */
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <limits.h>
#include <string.h>
#include <errno.h>
#include <stdbool.h>
#include "sysfs.h"
#include "watch.h"

long int hotplug_partition(const char *name)
{
  char namebuf[NAME_MAX+1], *pathname;
  int fd, devfd; /* file descriptors */
  struct stat buf;
  char line[16]={0};
  bool hoplug_ok = false;
  int rc, size;
  
  if( !(pathname=devpath(name, namebuf)) )
    {
      fprintf(stderr, _("%s cannot find sys path for %s.\n"), progname, name);
      goto close0;
    }
 
  /* open directory pointed to by pathname */ 
  if( (devfd=open(pathname, O_RDONLY)) < 0 )
    {
      fprintf(stderr, _("%s cannot open %s: %s.\n"),
	      progname, name, strerror(errno));
      goto close0;
    }

  /* check the directory contains a file named "partition" */
  rc = fstatat( devfd, "partition", &buf, 0);
  if(rc) goto close1;

  /* open file "size" */
  if( (fd=openat(devfd, "size", O_RDONLY)) < 0 )
    {
      fprintf(stderr,
	      _("%s: can't find size file: %s.\n"), progname, name);
      goto close1;
    }
    
  rc = read(fd, line, sizeof(line));
  if (rc == -1)
    {
      fprintf(stderr,
	      _("%s cannot read size file: %s.\n"),
	      progname, strerror(errno));
      goto close2;
    }
  
  // Read does not add the terminating \0
  // We can use the number of read characters as the index
  // of the last character in the string
  line[rc] = '\0';
  line[strcspn(line, "\n")] = '\0';
  size=atol(line);
  ///if(size<1000) goto close2;
  
  //rc = sysfs_get_parent_with_subsystem_devtype(pathname, "usb", "usb_interface");
  //if(rc) goto close1;
  
  hoplug_ok = true;

  close2: close(fd);
  close1: close(devfd);
  close0: 
    if(!hoplug_ok)
      return 0;
    else
      return size;
}
